   /*-----------------------------------------------------------.   
  /                           Dither                            /
  '-----------------------------------------------------------*/
/* 
  Dither version 1.0.2
  by Christian Cann Schuldt Jensen ~ CeeJay.dk
  
  Does dithering of the greather than 8-bit per channel precision used in shaders.
  Even halfs offer 10(+1)bit per channel
*/

float4 DitherPass( float4 colorInput, float2 tex )
{

   float4 color = colorInput;
   //color = tex.x / 2.0; //draw a gradient for testing.
   
   float dither_size = 2.0;  //move to settings?
   float dither_bit  = 8.0;  //move to settings?
   
   /*
   //method 1 (works but not that fast)
   float pixel_position = dot(tex,screen_size);
   float grid_position = round(pixel_position) % dither_size;
   */

   /*
   //method 2 (faster)
   float pixel_position = dot(tex,(screen_size / dither_size));
   float grid_position = abs(round(pixel_position) - pixel_position); 
   */
   
   //method 3 (fastest)
   float pixel_position = dot(tex,(screen_size / dither_size));
   float grid_position = abs(ceil(pixel_position) - pixel_position);
   //float grid_position = abs((ceil(pixel_position) - pixel_position)* 2.0);
   
   /*
   //method 4 (doesn't work right)
   float pixel_position = dot(tex,(screen_size / dither_size));
   float grid_position = abs(frac(pixel_position));      
   */
   
   float dither_shift = (0.25) * (1.0 / (pow(2,dither_bit) - 1.0)); // 0.25 seems good both when using math and when eyeballing it. So does 0.75 btw.
       
   color += lerp(dither_shift,(-dither_shift*3.0),grid_position); //shift the color by dither_shift
   //color += lerp(dither_shift,(-dither_shift),grid_position); //shift the color by dither_shift

   //color = (grid_position > (0.99999997)) ? 1.00 : 0.00; //precision test
   
   return color;
   //return grid_position.xxxx; //visualize grid for debugging purposes
}